/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.images;

import com.andavin.images.Versioned;
import com.andavin.images.image.CustomImage;
import com.andavin.images.image.CustomImageSection;
import com.andavin.util.Scheduler;
import java.util.List;
import java.util.function.Supplier;
import org.bukkit.entity.Player;

public abstract class PacketListener<T, U>
implements Versioned {
    static Supplier<List<CustomImage>> getImages;

    protected abstract void setEntityListener(Player var1, ImageListener var2);

    protected abstract void handle(Player var1, ImageListener var2, T var3);

    protected abstract void handle(Player var1, U var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CustomImageSection getImageSection(int mapId) {
        List<CustomImage> images;
        List<CustomImage> list = images = getImages.get();
        synchronized (list) {
            for (CustomImage image : images) {
                CustomImageSection section = image.getSectionByMap(mapId);
                if (section == null) continue;
                return section;
            }
            return null;
        }
    }

    public static void call(Player player, int entityId, InteractType action, Hand hand, ImageListener listener) {
        if (entityId < 0x1FFFFFFF) {
            return;
        }
        Scheduler.async(() -> {
            List<CustomImage> images;
            List<CustomImage> list = images = getImages.get();
            synchronized (list) {
                for (CustomImage image : images) {
                    CustomImageSection section = image.getSection(entityId);
                    if (section == null) continue;
                    listener.click(player, image, section, action, hand);
                    return;
                }
            }
        });
    }

    public static interface ImageListener {
        public void click(Player var1, CustomImage var2, CustomImageSection var3, InteractType var4, Hand var5);
    }

    public static enum InteractType {
        LEFT_CLICK,
        RIGHT_CLICK;

    }

    public static enum Hand {
        OFF_HAND,
        MAIN_HAND;

    }
}

